/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.certs;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.certs.CertMgtConstants;
import com.ibm.hwmca.fw.certs.CertMgtPanelUtils;
import com.ibm.hwmca.fw.certs.CertPrincipal;
import com.ibm.hwmca.fw.certs.DNSAndIPAddrListBoxesInterface;
import com.ibm.hwmca.fw.certs.SelfSignedServerCert;
import com.ibm.hwmca.fw.certs.ServerCert;
import com.ibm.hwmca.fw.certs.SubjectAltNames;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.DataBean;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.UserTaskManager;
import com.ibm.ui.framework.ValueDescriptor;
import java.util.HashSet;

public class NewServerCertBean
extends PanelBean
implements DataBean,
CertMgtConstants,
DNSAndIPAddrListBoxesInterface {
    private static final String TRACE_MASKD = "XCRTNEWD";
    private static final String TRACE_MASKF = "XCRTNEWF";
    private static final String TRACE_MASKT = "XCRTNEWT";
    private ServerCert originalCertificate = null;
    private boolean selfSigned;
    private String m_sIntroLabel;
    private String m_sOrganization;
    private String m_sOrganizationUnit;
    private String m_sCountry;
    private String m_sState;
    private String m_sLocality;
    private String m_sNumberOfDaysValid;
    private String m_sEMailAddr;
    private String m_sDNSEntry;
    private String m_sDNSListBox;
    private ValueDescriptor[] m_vdDNSListBox;
    private String m_sIPAddrNetworkByte0;
    private String m_sIPAddrNetworkByte1;
    private String m_sIPAddrNetworkByte2;
    private String m_sIPAddrNetworkByte3;
    private String m_sIPAddrListBox;
    private ValueDescriptor[] m_vdIPAddrListBox;

    public NewServerCertBean(ServerCert certificate, String name, boolean selfSigned) {
        this.originalCertificate = certificate;
        this.selfSigned = selfSigned;
        this.setBeanName(name);
        Trace.trace(TRACE_MASKT, "<->NewServerCertBean(" + certificate + ", " + name + ", " + selfSigned + ")");
    }

    public void setIntroLabel(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<->setIntroLabel(" + s + ")");
        this.m_sIntroLabel = s;
    }

    public String getIntroLabel() {
        Trace.trace(TRACE_MASKT, "<->getIntrolLabel() returning " + this.m_sIntroLabel);
        return this.m_sIntroLabel;
    }

    public void setOrganization(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<->setOrganization(" + s + ")");
        this.m_sOrganization = s;
    }

    public String getOrganization() {
        Trace.trace(TRACE_MASKT, "<->getOrganization() returning " + this.m_sOrganization);
        return this.m_sOrganization;
    }

    public void setOrganizationUnit(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<->setOrganizationUnit(" + s + ")");
        this.m_sOrganizationUnit = s;
    }

    public String getOrganizationUnit() {
        Trace.trace(TRACE_MASKT, "<->getOrganizationUnit() returning " + this.m_sOrganizationUnit);
        return this.m_sOrganizationUnit;
    }

    public void setCountry(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<->setCountry(" + s + ")");
        if (s.length() != 2) {
            throw new IllegalUserDataException(new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0060").toString());
        }
        this.m_sCountry = s;
    }

    public String getCountry() {
        Trace.trace(TRACE_MASKT, "<->getCountry() returning " + this.m_sCountry);
        return this.m_sCountry;
    }

    public void setState(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<->setState(" + s + ")");
        this.m_sState = s;
    }

    public String getState() {
        Trace.trace(TRACE_MASKT, "<->getState() returning " + this.m_sState);
        return this.m_sState;
    }

    public void setLocality(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<->setLocality(" + s + ")");
        this.m_sLocality = s;
    }

    public String getLocality() {
        Trace.trace(TRACE_MASKT, "<->getLocality() returning " + this.m_sLocality);
        return this.m_sLocality;
    }

    public void setNumberOfDaysValid(String s) throws IllegalUserDataException {
        int temp = 0;
        Trace.trace(TRACE_MASKT, "<->setNumberOfDaysValid(" + s + ")");
        try {
            temp = new Integer(s);
            if (temp < 1) {
                throw new IllegalUserDataException(new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0059").toString());
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalUserDataException(new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0058").toString());
        }
        this.m_sNumberOfDaysValid = s;
    }

    public String getNumberOfDaysValid() {
        Trace.trace(TRACE_MASKT, "<->getNumberOfDaysValid() returning " + this.m_sNumberOfDaysValid);
        return this.m_sNumberOfDaysValid;
    }

    public void setEMailAddr(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<->setEMailAddr(" + s + ")");
        this.m_sEMailAddr = s;
    }

    public String getEMailAddr() {
        Trace.trace(TRACE_MASKT, "<->getEMailAddr() returning " + this.m_sEMailAddr);
        return this.m_sEMailAddr;
    }

    public void setDNSEntry(String s) throws IllegalUserDataException {
        String valueToSet = null;
        Trace.trace(TRACE_MASKT, "<->setDNSEntry(" + s + ")");
        if (s != null && (valueToSet = s.trim()).length() > 0) {
            this.m_sDNSEntry = valueToSet;
            return;
        }
        throw new IllegalUserDataException(new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0009").toString());
    }

    public void setDNSEntryWithoutChecks(String s) {
        Trace.trace(TRACE_MASKT, "<->setDNSEntry(" + s + ")");
        this.m_sDNSEntry = s;
    }

    public String getDNSEntry() {
        Trace.trace(TRACE_MASKT, "<->getDNSEntry() returning " + this.m_sDNSEntry);
        return this.m_sDNSEntry;
    }

    public ValueDescriptor[] getDNSListBoxList() {
        Trace.trace(TRACE_MASKT, "<->getDNSListBoxList() returning " + this.m_vdDNSListBox);
        return this.m_vdDNSListBox;
    }

    public void setDNSListBoxList(ValueDescriptor[] values) {
        Trace.trace(TRACE_MASKT, "<->setDNSListBoxList(" + values + ")");
        this.m_vdDNSListBox = values;
    }

    public void setDNSListBox(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<->setDNSListBox(" + s + ")");
        this.m_sDNSListBox = s;
    }

    public String getDNSListBox() {
        Trace.trace(TRACE_MASKT, "<->getDNSListBox() returning " + this.m_sDNSListBox);
        return this.m_sDNSListBox;
    }

    public void setIPAddrNetworkByte0(String s) throws IllegalUserDataException {
        int valueToSet = 0;
        Trace.trace(TRACE_MASKT, "<->setIPAddrNetworkByte0(" + s + ")");
        if (s != null) {
            try {
                valueToSet = Integer.parseInt(s);
                if (valueToSet >= 0 && valueToSet <= 255) {
                    this.m_sIPAddrNetworkByte0 = String.valueOf(valueToSet);
                    return;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        throw new IllegalUserDataException(new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0010").toString());
    }

    public void setIPAddrNetworkByte0WithoutChecks(String s) {
        Trace.trace(TRACE_MASKT, "<->setIPAddrNetworkByte0WithoutChecks(" + s + ")");
        this.m_sIPAddrNetworkByte0 = s;
    }

    public String getIPAddrNetworkByte0() {
        Trace.trace(TRACE_MASKT, "<->getIPAddrNetworkByte0() returning " + this.m_sIPAddrNetworkByte0);
        return this.m_sIPAddrNetworkByte0;
    }

    public void setIPAddrNetworkByte1(String s) throws IllegalUserDataException {
        int valueToSet = 0;
        Trace.trace(TRACE_MASKT, "<->setIPAddrNetworkByte1(" + s + ")");
        if (s != null) {
            try {
                valueToSet = Integer.parseInt(s);
                if (valueToSet >= 0 && valueToSet <= 255) {
                    this.m_sIPAddrNetworkByte1 = String.valueOf(valueToSet);
                    return;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        throw new IllegalUserDataException(new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0010").toString());
    }

    public void setIPAddrNetworkByte1WithoutChecks(String s) {
        Trace.trace(TRACE_MASKT, "<->setIPAddrNetworkByte1WithoutChecks(" + s + ")");
        this.m_sIPAddrNetworkByte1 = s;
    }

    public String getIPAddrNetworkByte1() {
        Trace.trace(TRACE_MASKT, "<->getIPAddrNetworkByte1() returning " + this.m_sIPAddrNetworkByte1);
        return this.m_sIPAddrNetworkByte1;
    }

    public void setIPAddrNetworkByte2(String s) throws IllegalUserDataException {
        int valueToSet = 0;
        Trace.trace(TRACE_MASKT, "<->setIPAddrNetworkByte2(" + s + ")");
        if (s != null) {
            try {
                valueToSet = Integer.parseInt(s);
                if (valueToSet >= 0 && valueToSet <= 255) {
                    this.m_sIPAddrNetworkByte2 = String.valueOf(valueToSet);
                    return;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        throw new IllegalUserDataException(new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0010").toString());
    }

    public void setIPAddrNetworkByte2WithoutChecks(String s) {
        Trace.trace(TRACE_MASKT, "<->setIPAddrNetworkByte2WithoutChecks(" + s + ")");
        this.m_sIPAddrNetworkByte2 = s;
    }

    public String getIPAddrNetworkByte2() {
        Trace.trace(TRACE_MASKT, "<->getIPAddrNetworkByte2() returning " + this.m_sIPAddrNetworkByte2);
        return this.m_sIPAddrNetworkByte2;
    }

    public void setIPAddrNetworkByte3(String s) throws IllegalUserDataException {
        int valueToSet = 0;
        Trace.trace(TRACE_MASKT, "<->setIPAddrNetworkByte3(" + s + ")");
        if (s != null) {
            try {
                valueToSet = Integer.parseInt(s);
                if (valueToSet >= 0 && valueToSet <= 255) {
                    this.m_sIPAddrNetworkByte3 = String.valueOf(valueToSet);
                    return;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        throw new IllegalUserDataException(new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0010").toString());
    }

    public void setIPAddrNetworkByte3WithoutChecks(String s) {
        Trace.trace(TRACE_MASKT, "<->setIPAddrNetworkByte3WithoutChecks(" + s + ")");
        this.m_sIPAddrNetworkByte3 = s;
    }

    public String getIPAddrNetworkByte3() {
        Trace.trace(TRACE_MASKT, "<->getIPAddrNetworkByte3() returning " + this.m_sIPAddrNetworkByte3);
        return this.m_sIPAddrNetworkByte3;
    }

    public ValueDescriptor[] getIPAddrListBoxList() {
        Trace.trace(TRACE_MASKT, "<->getIPAddrListBoxList() returning " + this.m_vdIPAddrListBox);
        return this.m_vdIPAddrListBox;
    }

    public void setIPAddrListBoxList(ValueDescriptor[] values) {
        Trace.trace(TRACE_MASKT, "<->setIPAddrListBoxList(" + values + ")");
        this.m_vdIPAddrListBox = values;
    }

    public void setIPAddrListBox(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<->setIPAddrListBox(" + s + ")");
        this.m_sIPAddrListBox = s;
    }

    public String getIPAddrListBox() {
        Trace.trace(TRACE_MASKT, "<->getIPAddrListBox() returning " + this.m_sIPAddrListBox);
        return this.m_sIPAddrListBox;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void load() {
        this.m_sIntroLabel = this.originalCertificate == null ? (this.selfSigned ? new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "newSelfSignedCertIntroLabel").toString() : new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "newCASignedCertIntroLabel").toString()) : new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "modifyCertIntroLabel").toString();
        this.m_sOrganization = "";
        this.m_sOrganizationUnit = "";
        this.m_sCountry = "";
        this.m_sState = "";
        this.m_sLocality = "";
        this.m_sNumberOfDaysValid = "";
        this.m_sEMailAddr = "";
    }

    public void save() {
    }

    public void panelAction(TaskActionEvent event) {
        block13: {
            String elementName;
            block15: {
                CertPrincipal modifiedSubject;
                String eMailAddr;
                String locality;
                String state;
                String country;
                String organizationUnit;
                String organization;
                block18: {
                    String action;
                    HashSet alternateIPAddresses;
                    HashSet alternateDNSNames;
                    SubjectAltNames altSubjectNames;
                    SelfSignedServerCert partialServerCert;
                    String numOfDaysValid;
                    UserTaskManager utm;
                    block17: {
                        block16: {
                            String actionCommand;
                            block14: {
                                elementName = null;
                                actionCommand = null;
                                utm = null;
                                organization = null;
                                organizationUnit = null;
                                country = null;
                                state = null;
                                locality = null;
                                numOfDaysValid = null;
                                eMailAddr = null;
                                partialServerCert = null;
                                altSubjectNames = null;
                                alternateDNSNames = null;
                                alternateIPAddresses = null;
                                action = null;
                                modifiedSubject = null;
                                Trace.trace(TRACE_MASKT, "->panelAction() : \n\tBean Name     : " + this.getBeanName() + "\n\tCurrentElement: " + event.getCurrentElement() + "\n\tElementName   : " + event.getElementName() + "\n\tActionCommand : " + event.getActionCommand());
                                if (event == null) break block13;
                                elementName = event.getElementName();
                                actionCommand = event.getActionCommand();
                                utm = this.getUserTaskManager();
                                if (!actionCommand.equals("AddDNSButton") && !actionCommand.equals("AddIPAddrButton") && !actionCommand.equals("RemoveDNSButton") && !actionCommand.equals("RemoveIPAddrButton")) break block14;
                                CertMgtPanelUtils.handleDNSAndIPAddrListBoxes(actionCommand, elementName, utm, this, this.getMountPrefix(), this.originalCertificate);
                                break block13;
                            }
                            if (!actionCommand.equals("NewServerCertOKButton")) break block15;
                            organization = this.trimEntryField(this.getOrganization());
                            organizationUnit = this.trimEntryField(this.getOrganizationUnit());
                            country = this.trimEntryField(this.getCountry());
                            state = this.trimEntryField(this.getState());
                            locality = this.trimEntryField(this.getLocality());
                            numOfDaysValid = this.trimEntryField(this.getNumberOfDaysValid());
                            eMailAddr = this.trimEntryField(this.getEMailAddr());
                            if (organization != null && organizationUnit != null && country != null && state != null && locality != null && numOfDaysValid != null && eMailAddr != null) break block16;
                            if (utm != null) {
                                try {
                                    CommonMsgApp.showMessageBox(utm, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0007"), new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0017"), MsgType.ERROR_MESSAGE);
                                }
                                catch (HException e) {
                                    new FrameworkLog(CertMgtConstants.LOG_INFO, 4, e).log();
                                }
                            }
                            break block13;
                        }
                        if (country.length() == 2) break block17;
                        if (utm != null) {
                            try {
                                CommonMsgApp.showMessageBox(utm, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0007"), new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0018"), MsgType.ERROR_MESSAGE);
                            }
                            catch (HException e) {
                                new FrameworkLog(CertMgtConstants.LOG_INFO, 4, e).log();
                            }
                        }
                        break block13;
                    }
                    if (this.originalCertificate != null) break block18;
                    altSubjectNames = CertMgtPanelUtils.getSubjectAltNames(this.getDNSListBoxList(), this.getIPAddrListBoxList());
                    if (altSubjectNames != null) {
                        alternateDNSNames = altSubjectNames.getDNSNames();
                        alternateIPAddresses = altSubjectNames.getIPAddrNames();
                    }
                    partialServerCert = new SelfSignedServerCert(new Integer(numOfDaysValid), country, state, locality, organization, organizationUnit, null, eMailAddr, alternateDNSNames, alternateIPAddresses);
                    try {
                        action = this.selfSigned ? "finishSelfSignedServerCert" : "finishCASignedServerCert";
                        CertMgtPanelUtils.sendTaskletRequest(action, partialServerCert, null, null, this);
                    }
                    catch (NumberFormatException e) {
                        if (utm == null) break block13;
                        try {
                            CommonMsgApp.showMessageBox(utm, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0007"), new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0019"), MsgType.ERROR_MESSAGE);
                            break block13;
                        }
                        catch (HException e2) {
                            new FrameworkLog(CertMgtConstants.LOG_INFO, 4, e2).log();
                        }
                    }
                    break block13;
                }
                modifiedSubject = new CertPrincipal(country, state, locality, organization, organizationUnit, this.originalCertificate.getSubject().getHostName(), eMailAddr);
                CertMgtPanelUtils.sendTaskletRequest("finishSubject", modifiedSubject, null, this.originalCertificate, this);
                break block13;
            }
            if (elementName.equals("CancelButton")) {
                CertMgtPanelUtils.sendCancelRequest(this);
            } else {
                Trace.trace(TRACE_MASKF, "Unknown event received in panelAction(...).");
                new FrameworkLog(CertMgtConstants.LOG_INFO, 7).log();
            }
        }
        Trace.trace(TRACE_MASKT, "<-panelAction(...)");
    }

    private String trimEntryField(String s) {
        String result = null;
        if (s != null && (result = s.trim()).length() == 0) {
            result = null;
        }
        return result;
    }

    public PanelBean getPanelBean() {
        return this;
    }
}

